%% Three Kingdoms Optimization Algorithm (TKOA)
function [svc_abs,best_X,Convergence_curve] = TKOA(N,MaxFEs,lb,ub,dim,fhd,fNumber)

tolerance = 1e-4;			% Final tolerance for equality constraints (Fixed according the competence)
cut_off = 0.6;				% Proportion of FEs before drop dynamic tolerance value

best_X=zeros(1,dim);
best_fit=inf;      % change this to -inf for maximization problems
new_X=zeros(N,dim);
new_f=inf.*ones(1,N);
FEs=0;
%% 1. Ascent of might
X = lb + ub.*rand(N,dim); % Initialize the population
fit= zeros(1,N);
Destination_fitness=inf;  % change this to -inf for maximization problems
%% Evaluation of population objective function values
[f, g, h] = fobj(X,fhd,fNumber);
fit=f';
g = g';								% transposes constraints
h = h';								% Re-transpose for keep consistence
FEs = FEs + N;

%% Initialization constraint violation of population
[svc, ~] = get_svc(g, h, 0.);
% Sort the population to achieve the feasible solution with the minimum fitness value at the forefront
[X, fit, g, h, ~, ~] = sort_pop(X, fit, g, h, svc, svc);
tolerance_i = max(abs(h)); % The absolute value of the maximum equality constraint violation
tolerance_i = max(tolerance_i, tolerance); % The tolerance of equality constraints cannot be less than the set value
cut_off = cut_off * MaxFEs;
% Recalculate constraint violation based on dynamic equality constraint tolerance
[svc, ~] = get_svc(g, h, tolerance_i);
% Calculate the true constraint violation value of the population
[svc_abs, ~] = get_svc(g, h, tolerance);
% Reorder the population according to the constraint violation values of the true population
[X, fit, g, h, ~, svc_abs] = sort_pop(X, fit, g, h, svc, svc_abs);
best_fit=fit(1,1);
best_X=X(1,:);

V=4;
Time = 1;
Convergence_curve = [];
Convergence_curve(Time) = best_fit;

while FEs <= MaxFEs
    %% Update equality constraint tolerance
    [svc, h_sum] = get_svc(g, h, tolerance_i); % h_sum: Record all violations of equality constraints
    if any(h_sum==0) && any(tolerance_i > tolerance) && (FEs < cut_off)
        tolerance_i = get_tolerance(h, tolerance_i, tolerance, cut_off - FEs, h_sum);  % Adjust the tolerance of equality constraints
        [svc, ~] = get_svc(g, h, tolerance_i);         % Recalculating population constraints violates
    end
    % Exceeding the limit on the number of evaluations for adjustment
    if (FEs >= cut_off) && any(tolerance_i > tolerance)
        tolerance_i = tolerance;				% Changing from array to scalar
        [svc, ~] = get_svc(g, h, tolerance_i);
    end
    % Select the top three individuals
    if N>=3
        [~,SmellIndex] =sort(fit);
        abc_X=X(SmellIndex(1:3),:);
    else
        for m=1:3
            abc_X(m,:)=best_X;
        end
    end
    power=sqrt((FEs-1)/MaxFEs);
    for i=1:N
        %% 2. Joint confrontation
        powerLine=(power)^(1-tan(pi*(rand-0.5))/MaxFEs);
        if powerLine<rand
            for j=1:dim
                r1=unifrnd(0,1);
                r2=unifrnd(0,1);
                temp1=r1.*abc_X(2 ,j)+(1-r1).*X(i,j)+rand*((ub(j)-lb(j))*rand+lb(j));%
                temp2=r2.*abc_X(3 ,j)+(1-r2).*X(i,j)+rand*((ub(j)-lb(j))*rand+lb(j));%
                wight=rand;
                new_X(i,j)=wight*temp1+(1-wight)*temp2;
            end
            %% 3. Three legged tripod
        else
            Index=randi([1,3]);
            rr = floor(rand()* N) + 1;
            while rr ==i,rr = floor(rand()* N) + 1;end
            [m,~] = min([fit(1,rr),fit(1,i)]);
            if m == fit(1,rr), betterX=X(rr,:); else, betterX=X(i,:); end
            moveStep1=rand(1,dim).* (abc_X(Index,:)-betterX);
            moveStep2=rand(1,dim).* (betterX - X(i,:));
            new_X(i,:)=betterX+(moveStep1+moveStep2).*Levy(dim);
        end
        %% Boundary absorption
        %new_X(i,:) = han_boun (new_X(i,:), ub, lb, X(i,:), 4);
        for j=1:dim
            if new_X(i,j)>ub(j)
                r_u = 0.1*rand();
                new_X(i,j)=(1-r_u)*ub(j)+r_u*new_X(i,j);
            elseif new_X(i,j)<lb(j)
                r_l = 0.1*rand();
                new_X(i,j)=(1-r_l)*lb(j)+r_l*new_X(i,j);
            end
        end
    end
    % Evaluation of population objective function values
    [new_fit, new_g, new_h] = fobj(new_X(i,:),fhd,fNumber);
    new_f=new_fit';
    new_g = new_g';								% Transposes constraints
    new_h = new_h';								% Re-transpose for keep consistence
    FEs = FEs+ 1;
    % svc_u: Calculating offspring populations based on dynamic tolerance adjustment for constraint violations
    [svc_u, ~] = get_svc(new_g, new_h, tolerance_i);
    % svc_u_abs: Violation of constraints in computing offspring populations
    [svc_u_abs, ~] = get_svc(new_g, new_h, tolerance);

    %% Update population and memory
    % Parent population: x, f, g, h, svc, svc_abs
    % Offspring population: new_X, new_f, new_g, new_h, svc_u, svc_u_abs
    [X, fit, g, h, svc, svc_abs] = deb_tournament_i(i, X, fit, g, h, svc, svc_abs,new_X(i,:), new_f, new_g, new_h, svc_u, svc_u_abs,tolerance_i, tolerance);
    [X, fit, g, h, svc, svc_abs] = sort_pop(X, fit, g, h, svc, svc_abs);
    best_fit=fit(1,1);
    best_X=X(1,:);

    %% 4. Whole country united
    currentPower=sech(mapminmax(abs(fit-best_fit),0,1).*V);
    for j = 1:dim
        R2=rand;
        if currentPower(i)>R2
            new_X(i,j)= X(i,j);
        else
            new_X(i,j)=power*best_X(1,j)+(1-power)*X(i,j)+rand*(best_X(1,j)-X(1,j));
            %% Boundary absorption
            if new_X(i,j)>ub(j)
                r_u = 0.1*rand();
                new_X(i,j)=(1-r_u)*ub(j)+r_u*new_X(i,j);
            elseif new_X(i,j)<lb(j)
                r_l = 0.1*rand();
                new_X(i,j)=(1-r_l)*lb(j)+r_l*new_X(i,j);
            end
        end
    end

    % Evaluation of population objective function values
    [new_fit, new_g, new_h] = fobj(new_X(i,:),fhd,fNumber);
    new_f=new_fit';
    new_g = new_g';								% Transposes constraints
    new_h = new_h';								% Re-transpose for keep consistence
    FEs = FEs+ 1;
    % svc_u: Calculating offspring populations based on dynamic tolerance adjustment for constraint violations
    [svc_u, ~] = get_svc(new_g, new_h, tolerance_i);
    % svc_u_abs: Violation of constraints in computing offspring populations
    [svc_u_abs, ~] = get_svc(new_g, new_h, tolerance);

    %% Update population and memory
    % Parent population: x, f, g, h, svc, svc_abs
    % Offspring population: new_X, new_f, new_g, new_h, svc_u, svc_u_abs
    [X, fit, g, h, svc, svc_abs] = deb_tournament_i(i, X, fit, g, h, svc, svc_abs,new_X(i,:), new_f, new_g, new_h, svc_u, svc_u_abs,tolerance_i, tolerance);
    [X, fit, g, h, svc, svc_abs] = sort_pop(X, fit, g, h, svc, svc_abs);
    % Update the optimal individual information
    best_fit=fit(1,1);
    best_X=X(1,:);
end

%% Modify the optimal objective function value record
if best_fit < Destination_fitness
    Destination_fitness = best_fit;
end
Time=Time+1;
if svc_abs(1)==0
    Convergence_curve(Time)=Destination_fitness;
else
    Convergence_curve(Time)=Convergence_curve(Time-1);
end
end
function o=Levy(d)
beta=1.5;
sigma=(gamma(1+beta)*sin(pi*beta/2)/(gamma((1+beta)/2)*beta*2^((beta-1)/2)))^(1/beta);
u=randn(1,d)*sigma;v=randn(1,d);step=u./abs(v).^(1/beta);
o=step;
end
